ORCA/M Asm65816 2.1.0

0001 940E              **********************************************************************
0002 940E              *
0003 940E              * Integer Math Tool Patch
0004 940E              *
0005 940E              * Copyright (C) 1992-93
0006 940E              * Apple Computer, Inc.
0007 940E              * All Rights Reserved.
0008 940E              *
0009 940E              **********************************************************************
0010 940E              *
0011 940E              * REVISION HISTORY
0012 940E              *
0013 940E              * Begin 6.0.1
0014 940E              *
0015 940E              * 5-Mar-92          Dave Lyons
0016 940E              *
0017 940E              * New file.  Version $8301 for 6.0.1d2.
0018 940E              *
0019 940E              * Patch Int2Dec and Long2Dec:  If stringPtr bit 31 is set and the
0020 940E              * buffer length is at least 5, return zero as "zero " instead of
0021 940E              * blanks followed by a "0".
0022 940E              *
0023 940E              * 25-Mar-93         Dave Lyons
0024 940E              *
0025 940E              * Patched Multiply to see if we're being called from the Menu Manager
0026 940E              * routine AllocateCache.  If we are, clip one of the parameters to
0027 940E              * 200 so we don't try to allocate huge amounts of memory, MOD 64K.
0028 940E              *
0029 940E              * 2-Apr-93 DAL
0030 940E              *
0031 940E              * Version $0301 for 6.0.1.
0032 940E              *
0033 940E              **********************************************************************
0034 940E
0035 940E              IntMathVersion equ   $0301
0036 940E
0037 940E              **********************************************************************
0038 940E              *
0039 940E              * CALL TABLE
0040 940E              *
0041 940E              **********************************************************************
0042 940E              IMCallTable PROC EXPORT 
0043 940E                       import Long2DecPatch,Int2DecPatch,MultiplyPatch 
0044 940E                       import IMVersion 
0045 940E
0046 940E 2B 00 00 00           DC L:(TheEnd-IMCallTable)/4
0047 9412 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;power up init
0048 9416 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;application startup
0049 941A 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;application shutdown
0050 941E B9 97 02 00           DC L:IMVersion-1
0051 9422 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;reset
0052 9426 00 00 00 00           DC L:0                         ;  IMActive-1
0053 942A 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;reserved
0054 942E 00 00 00 00           DC L:0                         ;  oEndCall0-1     ;reserved
0055 9432 C3 97 02 00           DC L:MultiplyPatch-1           ;patched 25-Mar-93 DAL
0056 9436 00 00 00 00           DC L:0                         ;  SDivide-1
0057 943A 00 00 00 00           DC L:0                         ;  UDivide-1
0058 943E 00 00 00 00           DC L:0                         ;  LongMul-1
0059 9442 00 00 00 00           DC L:0                         ;  LongDiv-1
0060 9446 00 00 00 00           DC L:0                         ;  FixRatio-1
0061 944A 00 00 00 00           DC L:0                         ;  FixMul-1
0062 944E 00 00 00 00           DC L:0                         ;  FracMul-1
0063 9452 00 00 00 00           DC L:0                         ;  FixDiv-1
0064 9456 00 00 00 00           DC L:0                         ;  FracDiv-1
0065 945A 00 00 00 00           DC L:0                         ;  FixRound-1
0066 945E 00 00 00 00           DC L:0                         ;  FracSqrt-1
0067 9462 00 00 00 00           DC L:0                         ;  FracCos-1
0068 9466 00 00 00 00           DC L:0                         ;  FracSin-1
0069 946A 00 00 00 00           DC L:0                         ;  FixATan2-1
0070 946E 00 00 00 00           DC L:0                         ;  HiWord-1
0071 9472 00 00 00 00           DC L:0                         ;  LoWord-1
0072 9476 00 00 00 00           DC L:0                         ;  Long2Fix-1
0073 947A 00 00 00 00           DC L:0                         ;  Fix2Long-1
0074 947E 00 00 00 00           DC L:0                         ;  Fix2Frac-1
0075 9482 00 00 00 00           DC L:0                         ;  Frac2Fix-1
0076 9486 00 00 00 00           DC L:0                         ;  Fix2X-1
0077 948A 00 00 00 00           DC L:0                         ;  Frac2X-1
0078 948E 00 00 00 00           DC L:0                         ;  X2Fix-1
0079 9492 00 00 00 00           DC L:0                         ;  X2Frac-1
0080 9496 00 00 00 00           DC L:0                         ;  Int2Hex-1
0081 949A 00 00 00 00           DC L:0                         ;  Long2Hex-1
0082 949E 00 00 00 00           DC L:0                         ;  Hex2Int-1
0083 94A2 00 00 00 00           DC L:0                         ;  Hex2Long-1
0084 94A6 E3 97 02 00           DC L:Int2DecPatch-1            ;patched 5-Mar-92 DAL
0085 94AA 2F 98 02 00           DC L:Long2DecPatch-1
0086 94AE 00 00 00 00           DC L:0                         ;  Dec2Int-1
0087 94B2 00 00 00 00           DC L:0                         ;  Dec2Long-1
0088 94B6 00 00 00 00           DC L:0                         ;  HexIt-1
0089 94BA              TheEnd    
0090 94BA                       ENDP 
0091 94BA
0092 94BA
0093 94BA              **********************************************************************
0094 94BA              *
0095 94BA              * IMVersion
0096 94BA              *
0097 94BA              **********************************************************************
0098 94BA              IMVersion proc export 
0099 94BA
0100 94BA A9 01 03              lda   #IntMathVersion
0101 94BD 83 07                 sta   7,s
0102 94BF A9 00 00              lda   #0
0103 94C2 18                    clc   
0104 94C3 6B                    rtl   
0105 94C4
0106 94C4                       EndP 
0107 94C4
0108 94C4              **********************************************************************
0109 94C4              *
0110 94C4              * MultiplyPatch -- 25-Mar-93 DAL
0111 94C4              *
0112 94C4              * See if we're being called from $FD/8086 in the ROM 3 Memory Manager.
0113 94C4              * If we are, we must check the last parameter pushed and max it out
0114 94C4              * at 201, so we don't cause the Memory Manager to allocate way too
0115 94C4              * much memory, MOD 64K.  (If it tries to allocate 70K, then it only
0116 94C4              * allocates 6K instead, and then trashes memory.)
0117 94C4              *
0118 94C4              **********************************************************************
0119 94C4              MultiplyPatch proc 
0120 94C4
0121 94C4              boringRTL equ   1                       ;always $fe/0137
0122 94C4              usefulRTL equ   4                       ;check against $fd/8086
0123 94C4              lastOperand equ   7                     ;word to clip to 201
0124 94C4              firstOperand equ   9                    ;word
0125 94C4              resultSpace equ   11                    ;long
0126 94C4
0127 94C4 A3 04                 lda   usefulRTL,s
0128 94C6 C9 86 80              cmp   #$8086
0129 94C9 D0 15                 bne   @toROM
0130 94CB A3 05                 lda   usefulRTL+1,s
0131 94CD C9 80 FD              cmp   #$fd80
0132 94D0 D0 0E                 bne   @toROM
0133 94D2
0134 94D2 A3 07                 lda   lastOperand,s
0135 94D4 C9 C9 00              cmp   #201
0136 94D7 90 07                 bcc   @toROM
0137 94D9 A9 C9 00              lda   #201
0138 94DC 83 07                 sta   lastOperand,s
0139 94DE 85 EC                 sta   <$EC                     ;store new value at <cHeight on Menu Mgr dp
0140 94E0
0141 94E0 5C 05 F1 FE  @toROM   jml   >$fef105                 ;original ROM 3 Multiply (doesn't need AXY)
0142 94E4
0143 94E4                       EndP 
0144 94E4
0145 94E4              **********************************************************************
0146 94E4              *
0147 94E4              * Int2DecPatch -- 5-Mar-92 DAL
0148 94E4              *
0149 94E4              * Pre-patch the ROM to return "zero " if bit 31 of the string pointer
0150 94E4              * is set, the buffer length is at least 5, and the value is zero.
0151 94E4              *
0152 94E4              **********************************************************************
0153 94E4              Int2DecPatch proc 
0154 94E4
0155 94E4              signFlag equ   7
0156 94E4              buffLen  equ   9
0157 94E4              stringPtr equ   11
0158 94E4              value    equ   15                       ;word
0159 94E4
0160 94E4 A3 0F                 lda   value,s
0161 94E6 D0 13                 bne   @toROM
0162 94E8 A3 0D                 lda   stringPtr+2,s
0163 94EA 10 0F                 bpl   @toROM
0164 94EC A3 09                 lda   buffLen,s
0165 94EE CF 25 98 02           cmp   >theZeroStringLen
0166 94F2 90 07                 bcc   @toROM
0167 94F4
0168 94F4 20 FF 97              jsr   StuffZeroString          ;using stringPtr
0169 94F7 5C 5A FC FE           jml   >$fefc5a                 ;no error, strip 10 bytes
0170 94FB
0171 94FB 5C 68 F9 FE  @toROM   jml   $fef968                  ;old Int2Dec in ROM 3
0172 94FF
0173 94FF              *
0174 94FF              * StuffZeroString -- needs stringPtr and buffLen buried on stack
0175 94FF              *
0176 94FF                       export StuffZeroString 
0177 94FF 0B           StuffZeroString phd   
0178 9500 3B                    tsc   
0179 9501 5B                    tcd   
0180 9502              @buffLen equ   13
0181 9502              @stringPtr equ   15
0182 9502 E2 30                 sep   #$30
0183 9504                       longa off
0184 9504                       longi off
0185 9504 AF 25 98 02           lda   >theZeroStringLen
0186 9508 AA                    tax                            ;X counts backwards through source str
0187 9509 CA                    dex   
0188 950A
0189 950A A4 0D                 ldy   <@buffLen                ;right-justify the "zero " in the field
0190 950C 88                    dey   
0191 950D BF 27 98 02  @copy    lda   >theZeroString,x
0192 9511 97 0F                 sta   [<@stringPtr],y
0193 9513 88                    dey   
0194 9514 CA                    dex   
0195 9515 10 F6                 bpl   @copy
0196 9517
0197 9517              ; pad dest string with blanks
0198 9517 98                    tya   
0199 9518 30 07                 bmi   @done
0200 951A A9 20                 lda   #$20
0201 951C 97 0F        @padBlanks sta   [<@stringPtr],y
0202 951E 88                    dey   
0203 951F 10 FB                 bpl   @padBlanks
0204 9521              @done     
0205 9521 C2 30                 rep   #$30
0206 9523                       longa on
0207 9523                       longi on
0208 9523 2B                    pld   
0209 9524 60                    rts   
0210 9525
0211 9525                       export theZeroStringLen,theZeroString 
0212 9525 05 00        theZeroStringLen DC W:5
0213 9527 7A 65 72 6F  theZeroString DC B:'zero '
0214 952C 2A 2A 2A 2A           DC B:'****'                    ;space for internationalizing
0215 9530
0216 9530                       EndP 
0217 9530
0218 9530
0219 9530              **********************************************************************
0220 9530              *
0221 9530              * Long2DecPatch -- 5-Mar-92 DAL
0222 9530              *
0223 9530              * Pre-patch the old patch to return "zero " if bit 31 of the string
0224 9530              * pointer is set, the buffer length is at least 5, and the value is
0225 9530              * zero.
0226 9530              *
0227 9530              **********************************************************************
0228 9530              Long2DecPatch proc 
0229 9530                       import StuffZeroString 
0230 9530                       import theZeroStringLen,theZeroString 
0231 9530
0232 9530              signFlag equ   7
0233 9530              buffLen  equ   9
0234 9530              stringPtr equ   11
0235 9530              value    equ   15                       ;long
0236 9530
0237 9530 A3 0F                 lda   value,s
0238 9532 03 11                 ora   value+2,s
0239 9534 D0 13                 bne   @toROM
0240 9536 A3 0D                 lda   stringPtr+2,s
0241 9538 10 0F                 bpl   @toROM
0242 953A A3 09                 lda   buffLen,s
0243 953C CF 25 98 02           cmp   >theZeroStringLen        ;long enough?
0244 9540 90 07                 bcc   @toROM
0245 9542
0246 9542 20 FF 97              jsr   StuffZeroString          ;using stringPtr
0247 9545 5C 65 FC FE           jml   >$fefc65                 ;no error, strip 12 bytes
0248 9549
0249 9549 5C E5 F9 FE  @toROM   jml   >$fef9e5                 ;Long2Dec in ROM 3
0250 954D
0251 954D                       END   
